/*
 * Decompiled with CFR 0.152.
 */
package lib.toma.animations.engine.frame;

import java.util.HashMap;
import java.util.Map;
import lib.toma.animations.api.IKeyframeProvider;
import lib.toma.animations.api.IKeyframeTypeSerializer;
import lib.toma.animations.engine.frame.KeyframeProvider;
import lib.toma.animations.engine.frame.NoFramesProvider;
import lib.toma.animations.engine.frame.SingleFrameProvider;
import lib.toma.animations.engine.frame.TargetAndBackFrameProvider;

public final class FrameProviderType<FP extends IKeyframeProvider> {
    private static final Map<String, FrameProviderType<?>> TYPE_REGISTRY = new HashMap();
    public static final FrameProviderType<NoFramesProvider> EMPTY = new FrameProviderType<NoFramesProvider>("empty", new NoFramesProvider.Serializer());
    public static final FrameProviderType<SingleFrameProvider> SINGLE = new FrameProviderType<SingleFrameProvider>("single_frame", new SingleFrameProvider.Serializer());
    public static final FrameProviderType<TargetAndBackFrameProvider> TARGET_AND_BACK = new FrameProviderType<TargetAndBackFrameProvider>("target_back", new TargetAndBackFrameProvider.Serializer());
    public static final FrameProviderType<KeyframeProvider> KEYFRAME_PROVIDER_TYPE = new FrameProviderType<KeyframeProvider>("default", new KeyframeProvider.Serializer()).allowEvents();
    private final String typeKey;
    private final IKeyframeTypeSerializer<FP> serializer;
    private boolean supportEvents = false;

    public FrameProviderType(String typeKey, IKeyframeTypeSerializer<FP> serializer) {
        this.typeKey = typeKey;
        this.serializer = serializer;
        if (TYPE_REGISTRY.put(typeKey, this) != null) {
            throw new UnsupportedOperationException("Duplicate frame provider type key: " + typeKey);
        }
    }

    public String getKey() {
        return this.typeKey;
    }

    public IKeyframeTypeSerializer<FP> serializer() {
        return this.serializer;
    }

    public FrameProviderType<FP> allowEvents() {
        this.supportEvents = true;
        return this;
    }

    public boolean areEventsSupported() {
        return this.supportEvents;
    }

    public static <T extends IKeyframeProvider> FrameProviderType<T> getType(String key) {
        return TYPE_REGISTRY.get(key);
    }
}

